@extends('layouts.admin')

@section('title', 'Forum Categories')

@section('content')
<div class="users-management">
    <div class="users-header">
        <h2>Forum Categories</h2>
        <div class="users-actions">
            <a href="{{ route('admin.forum.categories.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Category
            </a>
        </div>
    </div>
    
    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Boards</th>
                            <th>Access</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($categories as $category)
                        <tr>
                            <td>{{ $category->order }}</td>
                            <td>
                                {{ $category->name }}
                                @if(!$category->is_public)
                                    <span class="forum-access-badge forum-access-badge--restricted">
                                        RESTRICTED
                                    </span>
                                @endif
                            </td>
                            <td>{{ $category->slug }}</td>
                            <td>{{ $category->boards->count() }}</td>
                            <td>
                                @if($category->is_public)
                                    <span class="user-role role-user">Public</span>
                                @else
                                    <div class="forum-access-info">
                                        @if($category->required_roles)
                                            <div class="forum-access-info__item">
                                                <strong>Roles:</strong> {{ implode(', ', $category->required_roles) }}
                                            </div>
                                        @endif
                                        @if($category->required_permissions)
                                            <div class="forum-access-info__item">
                                                <strong>Perms:</strong> {{ implode(', ', $category->required_permissions) }}
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </td>
                            <td>
                                <span class="user-role {{ $category->is_active ? 'role-moderator' : 'role-user' }}">
                                    {{ $category->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td class="user-actions">
                                <a href="{{ route('admin.forum.categories.edit', $category) }}" class="btn-icon" title="Edit Category">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.forum.categories.destroy', $category) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-icon btn-danger" title="Delete Category" onclick="return confirm('Are you sure you want to delete this category? This will also delete all boards and threads within it.')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center">No categories found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Access Control Legend --}}
            <div class="forum-access-legend">
                <h6 class="forum-access-legend__title">
                    <i class="fas fa-info-circle"></i> Access Control Legend
                </h6>
                <div class="forum-access-legend__content">
                    <div class="forum-access-legend__item">
                        <strong>Public:</strong> Accessible by all users (including guests)
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Roles:</strong> User must have at least ONE of the listed roles
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Perms:</strong> User must have ALL of the listed permissions
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Restricted categories</strong> are marked with a red badge
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection